﻿using System.Diagnostics;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
#if NUNIT
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;

namespace gov.va.med.vbecs.UnitTest.BOL
{
    [TestFixture]
    public class BOL_TestValidation : BaseTest
    {
        private string[] _posTestResults = {"1", "2", "3", "4"};
        private string[] _negTestResults = {"0"};
        private string[] _notTestedResults = {"X", ""};
        private string[] _aboInterps = {"A", "B", "AB", "O"};
        private string[] _rhInterps = {"P", "N"};
        private string[] _possibleTestResults = {"P", "N", "X"};
        private string[] _xmInterps = { "Compatible", "Incompatible" };
        private Random _rnd = new Random();
        private static Hashtable _resultLookup;

        private static Hashtable ResultLookup
        {
            get
            {
                if (_resultLookup == null)
                {
                    _resultLookup = new Hashtable();

                    // Empty results
                    _resultLookup.Add(string.Empty, "X");
                    _resultLookup.Add("X", "X");

                    _resultLookup.Add("1", "P");
                    _resultLookup.Add("2", "P");
                    _resultLookup.Add("3", "P");
                    _resultLookup.Add("4", "P");
                    _resultLookup.Add("0", "N");
                }

                return _resultLookup;
            }
        }

        [SetUp]
        protected void SetUp()
        {
            this.BaseSetUp();
        }

        [Test]
        public void TestValidation_ValidateUnitABORh_Pass()
        {
            string AntiA = "";
            string AntiB = "";
            string AntiAB = "";
            string AntiD = "";
            string DControl = "";
            string ABOInterp = "";
            string RhInterp = "";
            string LoginABO = "";
            string LoginRh = "";
            vbecs.BOL.TestValidationModel validationResult;
            string output = "";
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;
            int count = 0;
            bool testsPassed = true;
            System.IO.StreamWriter resultFile = null;

            try
            {
                resultFile = new System.IO.StreamWriter("\\\\DNS  SQLZUT\\AutobuildFiles\\TT_2Output" + DateTime.Now.ToString("yyMMddHHmmss") + ".txt");
                DataTable dtTT202 = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM dbo.TT2Checks");

                output = "Expected AntiA" + '\t' +
                         "Expected AntiB" + '\t' +
                         "Expected AntiAB" + '\t' +
                         "Expected AntiD" + '\t' +
                         "Expected DControl" + '\t' +
                         "Expected ABOInterp" + '\t' +
                         "Expected RhInterp" + '\t' +
                         "Expected UnitABO" + '\t' +
                         "Expected UnitRh" + '\t' +
                         "Expected Result" + '\t' +
                         "Expected Message" + '\t' +
                         "AntiA" + '\t' + 
                         "AntiB" + '\t' +
                         "AntiAB" + '\t' +
                         "AntiD" + '\t' +
                         "DControl" + '\t' +
                         "ABOInterp" + '\t' +
                         "RhInterp" + '\t' +
                         "UnitABO" + '\t' +
                         "UnitRh" + '\t' +
                         "Validation Result" + '\t' +
                         "Validation Message";

                resultFile.WriteLine(output);

                for (int i = 0; i < dtTT202.Rows.Count; i++)
                {
                    count++;
                    AntiA = GetRandomTestResult(dtTT202.Rows[i]["AntiA"].ToString().Trim());
                    AntiB = GetRandomTestResult(dtTT202.Rows[i]["AntiB"].ToString().Trim());
                    AntiAB = GetRandomTestResult(dtTT202.Rows[i]["AntiAB"].ToString().Trim());
                    AntiD = GetRandomTestResult(dtTT202.Rows[i]["AntiD"].ToString().Trim());
                    DControl = GetRandomTestResult(dtTT202.Rows[i]["DControl"].ToString().Trim());
                    ABOInterp = dtTT202.Rows[i]["UserABOInterp"].ToString().Trim();
                    RhInterp = dtTT202.Rows[i]["UserRhInterp"].ToString().Trim();
                    LoginABO = dtTT202.Rows[i]["LoginABO"].ToString().Trim();
                    LoginRh = dtTT202.Rows[i]["LoginRh"].ToString().Trim();

                    if (LoginABO == "Pooled")
                        LoginABO = "Mx";
                    if (LoginRh == "Pooled")
                        LoginRh = "Mx";

                    validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitABORh(AntiA, AntiB, AntiAB, AntiD,
                        DControl, ABOInterp, RhInterp, LoginABO, LoginRh, Guid.NewGuid(), UnitStatusCode.Limited);

                    string finalValidationResult = dtTT202.Rows[i]["ABORhErrorCode"].ToString();

                    /*if (dtTT202.Rows[i]["ABOErrorCode"].ToString() == "E" ||
                        dtTT202.Rows[i]["RhErrorCode"].ToString() == "E")
                        finalValidationResult = "E";
                    else if (dtTT202.Rows[i]["ABOErrorCode"].ToString() == "W" ||
                             dtTT202.Rows[i]["RhErrorCode"].ToString() == "W")
                        finalValidationResult = "W";
                    else
                    {
                        finalValidationResult = "V";
                    }*/

                    output = dtTT202.Rows[i]["AntiA"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["AntiB"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["AntiAB"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["AntiD"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["DControl"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["UserABOInterp"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["UserRhInterp"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["LoginABO"].ToString().Trim() + '\t' +
                             dtTT202.Rows[i]["LoginRh"].ToString().Trim() + '\t' +
                             finalValidationResult + '\t' +
                             dtTT202.Rows[i]["ABOErrorMessage"].ToString() + " " + dtTT202.Rows[i]["RhErrorMessage"].ToString() + '\t' +
                             AntiA + '\t' +
                             AntiB + '\t' +
                             AntiAB + '\t' +
                             AntiD + '\t' +
                             DControl + '\t' +
                             ABOInterp + '\t' +
                             RhInterp + '\t' +
                             LoginABO + '\t' +
                             LoginRh + '\t' +
                             validationResult.TestValidationStatus.ToString()[0] + '\t' +
                             validationResult.ErrorMessage.Replace(Environment.NewLine, " ");

                    resultFile.WriteLine(output);

                    string consoleOutput = dtTT202.Rows[i]["AntiA"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["AntiB"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["AntiAB"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["AntiD"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["DControl"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["UserABOInterp"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["UserRhInterp"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["LoginABO"].ToString().Trim() + '\t' +
                                           dtTT202.Rows[i]["LoginRh"].ToString().Trim() + '\t' +
                                           finalValidationResult + '\t' +
                                           dtTT202.Rows[i]["ABOErrorMessage"].ToString() + " " +
                                           dtTT202.Rows[i]["RhErrorMessage"].ToString() + '\t' +
                                           AntiA + '\t' +
                                           AntiB + '\t' +
                                           AntiAB + '\t' +
                                           AntiD + '\t' +
                                           DControl + '\t' +
                                           ABOInterp + '\t' +
                                           RhInterp + '\t' +
                                           LoginABO + '\t' +
                                           LoginRh + '\t' +
                                           validationResult.TestValidationStatus.ToString()[0] + '\t' +
                                           validationResult.ErrorMessage.Replace(Environment.NewLine, " ");

                    if (validationResult.TestValidationStatus == TestValidationStatus.Valid)
                    {
                        if (finalValidationResult != "V")
                        {
                            testsPassed = false;
                            Console.WriteLine(consoleOutput);
                        }
                    }
                    else if (validationResult.TestValidationStatus == TestValidationStatus.Warning)
                    {
                        if (finalValidationResult != "W")
                        {
                            testsPassed = false;
                            Console.WriteLine(consoleOutput);
                        }
                    }
                    else
                    {
                        if (finalValidationResult != "E")
                        {
                            testsPassed = false;
                            Console.WriteLine(consoleOutput);
                        }
                    }

                }
                resultFile.Close();
                Console.WriteLine("Number of combinations tested: " + count);
                Assert.IsTrue(testsPassed);
                Assert.IsTrue(count == dtTT202.Rows.Count);
                resultFile.Close();
}
            catch (Exception e)
            {
                if (resultFile != null)
                    resultFile.Close();

                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                Console.WriteLine("Number of combinations tested: " + count);
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidateUnitABORh_FinalStatus_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitABORh("1", "2","2", "0", "0", "AB","N", "AB","N",new Guid(), Common.UnitStatusCode.Transferred);
            Assert.AreEqual(validationResult.TestValidationStatus,TestValidationStatus.Error);
        }

        [Test]
        public void TestValidation_ValidateUnitABORh_NULL_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitABORh("1", "2", "2", "0", "0", "AB", "N", "AB", "N", null, Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Unknown);
        }

        [Test]
        public void TestValidation_ValidateUnitABORh_Fail()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitABORh("KMan", "2", "2", "0", "0", "AB", "N", "AB", "N", new Guid(), Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
            Assert.AreEqual(validationResult.ErrorMessage, "An error occurred trying to validate this test.");
        }

        [Test]
        public void TestValidation_ValidateUnitABORh_PooledGranulocytes_PooledABO_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitABORh("1", "2", "2", "0", "0", "AB", "N", "Mx", "N", new Guid(), Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
        }

        [Test]
        public void TestValidation_ValidateUnitABORh_PooledGranulocytes_PooledRh_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitABORh("1", "2", "2", "2", "0", "AB", "P", "AB", "Mx", new Guid(), Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
        }

        [Test]
        public void TestValidation_ValidateUnitAntigentyping_Pass()
        {
            string Result = "";
            string Interp = "";
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);

                for (int iResult = 0; iResult < _possibleTestResults.Length; iResult++)
                {
                    for (int iInterp = 0; iInterp < _possibleTestResults.Length; iInterp++)
                    {
                        Result = GetRandomTestResult(_possibleTestResults[iResult].ToString());
                        Interp = _possibleTestResults[iInterp].ToString();

                        validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitAntigentyping(Result, Interp, bloodUnit.BloodUnitGuid, "12", bloodUnit.BloodUnitStatus.UnitStatusCode);
                        if (ResultLookup[Result].ToString() == "X" || Interp == "X")
                            Assert.AreEqual(validationResult.TestValidationStatus,TestValidationStatus.Error);
                        else if (ResultLookup[Result].ToString() == Interp)
                            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                        else
                            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                    }
                }
                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidateUnitAntigentyping_41_12_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;
            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(),bloodUnit.BloodUnitGuid,Guid.Empty,Guid.Empty,207,"0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, Guid.Empty, Guid.Empty, 212, "N");

                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitAntigentyping("2", "P",
                    bloodUnit.BloodUnitGuid, "12", bloodUnit.BloodUnitStatus.UnitStatusCode);
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);
                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }
        }

        [Test]
        public void TestValidation_ValidateUnitAntigentyping_56_29_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;
            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;
                Guid _patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "");

                Guid patientTransfusionRequirementGuid = Guid.NewGuid();
                string sSQLInsertPTR = "INSERT INTO PatientTransfusionRequirement (";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.AntigenTypeId + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.CreateDate + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.CreateUser + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
                sSQLInsertPTR += "VALUES(";
                sSQLInsertPTR += "'" + patientTransfusionRequirementGuid.ToString() + "',";
                sSQLInsertPTR += "'" + _patientGuid.ToString() + "',";
                sSQLInsertPTR += "'K',";
                sSQLInsertPTR += "'" + Common.Utility.GetTransfusionCategoryCodeFromEnum(Common.TransfusionRequirementCategoryCode.AntigenNegative) + "',";
                sSQLInsertPTR += "'29',";
                sSQLInsertPTR += "'37',";
                sSQLInsertPTR += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sSQLInsertPTR += "'" + Common.LogonUser.LogonUserName + "',";
                sSQLInsertPTR += "'" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() + "',";
                sSQLInsertPTR += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sSQLInsertPTR += "'" + Common.LogonUser.LogonUserName + "',";
                sSQLInsertPTR += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO PatientTreatment (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + _patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'" + Common.LogonUser.LogonUserName + "',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO PatientOrder (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + this.TestDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserName + "',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedComponentGuid = Guid.NewGuid();
                string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
                insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
                insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
                insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
                insertOrderedComponent += "VALUES (";
                insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedComponent += "'1',";
                insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
                insertOrderedComponent += "'2',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'A',";
                insertOrderedComponent += "'I',";
                insertOrderedComponent += "'" + this.TestDivisionCode + "',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedUnitGuid = Guid.NewGuid();
                string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
                insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
                insertOrderedUnit += "VALUES (";
                insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "1,";
                insertOrderedUnit += "'C',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'A',";
                insertOrderedUnit += "'" + this.TestDivisionCode + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid issuedUnitGuid = Guid.NewGuid();
                string insertIssuedUnit = "INSERT INTO IssuedUnit (";
                insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
                insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
                insertIssuedUnit += "VALUES (";
                insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'10W P-KC',";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "1,";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sSQLInsertPTR);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedComponent);
                UnitTestUtil.RunSQL(insertOrderedUnit);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");
                UnitTestUtil.RunSQL(insertIssuedUnit);

                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitAntigentyping("2", "P",
                    bloodUnitGuid, "20", Common.UnitStatusCode.Issued);
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);
                DataKiller.ClearBloodUnitData(bloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }
        }

        [Test]
        public void TestValidation_ValidateUnitAntigentyping_FinalStatus_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitAntigentyping("1", "P", new Guid(), "12", Common.UnitStatusCode.Transferred);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
        }

        [Test]
        public void TestValidation_ValidateUnitAntigentyping_NULL_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitAntigentyping("1", "P", null, "12", Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Unknown);
        }

        [Test]
        public void TestValidation_ValidateUnitAntigentyping_Fail()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitAntigentyping("BUBU", "P", new Guid(), "12", Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
            Assert.AreEqual(validationResult.ErrorMessage, "An error occurred trying to validate this test.");
        }

        [Test]
        public void TestValidation_ValidateUnitWeakD_Pass()
        {
            string Result = "";
            string CC = "";
            string Interp = "";
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);

                for (int iUnitRhInterp = 0; iUnitRhInterp < _rhInterps.Length; iUnitRhInterp++)
                {
                    for (int iResult = 0; iResult < _possibleTestResults.Length; iResult++)
                    {
                        for (int iCC = 0; iCC < _possibleTestResults.Length; iCC++)
                        {
                            for (int iInterp = 0; iInterp < _possibleTestResults.Length; iInterp++)
                            {
                                Result = GetRandomTestResult(_possibleTestResults[iResult].ToString());
                                Result = GetRandomTestResult(_possibleTestResults[iCC].ToString());
                                Interp = _possibleTestResults[iInterp].ToString();

                                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitWeakD(Result, CC, Interp, bloodUnit.BloodUnitGuid,"11",_rhInterps[iUnitRhInterp].ToString(),
                                bloodUnit.BloodUnitStatus.UnitStatusCode);
                                if (ResultLookup[Result].ToString() == "X" || Interp == "X")
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                else if (_rhInterps[iUnitRhInterp].ToString() == "P")
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                else if (ResultLookup[Result].ToString() == "P" && (ResultLookup[CC].ToString() == "X" || ResultLookup[CC].ToString() == "N") && Interp == "N")
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                else if (ResultLookup[Result].ToString() == "N" && (ResultLookup[CC].ToString() == "X" || ResultLookup[CC].ToString() == "N") && Interp == "P")
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                else if (Interp == "P" && _rhInterps[iUnitRhInterp].ToString() == "N")
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);
                                else if (ResultLookup[CC].ToString() == "P")
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                else if (ResultLookup[Result].ToString() == Interp)
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                                else
                                    Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                            }
                        }
                    }
                }
                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidateUnitWeakD_41_12_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;
            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, Guid.Empty, Guid.Empty, 204, "2");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, Guid.Empty, Guid.Empty, 29, "0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, Guid.Empty, Guid.Empty, 206, "P");

                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitWeakD("0", "0", "N",
                    bloodUnit.BloodUnitGuid, "11", "N", bloodUnit.BloodUnitStatus.UnitStatusCode);
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);
                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }
        }

        [Test]
        public void TestValidation_ValidateUnitWeakD_41_22_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;
            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);

                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitWeakD("2", "0", "P",
                    bloodUnit.BloodUnitGuid, "11", "N", bloodUnit.BloodUnitStatus.UnitStatusCode);
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);
                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }
        }

        [Test]
        public void TestValidation_ValidateUnitWeakD_56_29_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;
            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;
                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() + new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() + "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTransfusionRequirementGuid = Guid.NewGuid();
                string sSQLInsertPTR = "INSERT INTO PatientTransfusionRequirement (";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.AntigenTypeId + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.CreateDate + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.CreateUser + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
                sSQLInsertPTR += "VALUES(";
                sSQLInsertPTR += "'" + patientTransfusionRequirementGuid.ToString() + "',";
                sSQLInsertPTR += "'" + patientGuid.ToString() + "',";
                sSQLInsertPTR += "'K',";
                sSQLInsertPTR += "'" + Common.Utility.GetTransfusionCategoryCodeFromEnum(Common.TransfusionRequirementCategoryCode.AntigenNegative) + "',";
                sSQLInsertPTR += "'29',";
                sSQLInsertPTR += "'37',";
                sSQLInsertPTR += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sSQLInsertPTR += "'" + Common.LogonUser.LogonUserName + "',";
                sSQLInsertPTR += "'" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() + "',";
                sSQLInsertPTR += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sSQLInsertPTR += "'" + Common.LogonUser.LogonUserName + "',";
                sSQLInsertPTR += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO PatientTreatment (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'" + Common.LogonUser.LogonUserName + "',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO PatientOrder (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + this.TestDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserName + "',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedComponentGuid = Guid.NewGuid();
                string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
                insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
                insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
                insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
                insertOrderedComponent += "VALUES (";
                insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedComponent += "'1',";
                insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
                insertOrderedComponent += "'2',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'A',";
                insertOrderedComponent += "'I',";
                insertOrderedComponent += "'" + this.TestDivisionCode + "',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedUnitGuid = Guid.NewGuid();
                string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
                insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
                insertOrderedUnit += "VALUES (";
                insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "1,";
                insertOrderedUnit += "'C',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'A',";
                insertOrderedUnit += "'" + this.TestDivisionCode + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid issuedUnitGuid = Guid.NewGuid();
                string insertIssuedUnit = "INSERT INTO IssuedUnit (";
                insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
                insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
                insertIssuedUnit += "VALUES (";
                insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'10W P-KC',";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "1,";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(sSQLInsertPTR);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedComponent);
                UnitTestUtil.RunSQL(insertOrderedUnit);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");
                UnitTestUtil.RunSQL(insertIssuedUnit);

                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitWeakD("2", "0", "P",
                    bloodUnitGuid, "11", "N", Common.UnitStatusCode.Issued);
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);
                DataKiller.ClearBloodUnitData(bloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }
        }

        [Test]
        public void TestValidation_ValidateUnitWeakD_FinalStatus_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitWeakD("1", "0", "P", new Guid(), "11", "P", Common.UnitStatusCode.Transferred);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
        }

        [Test]
        public void TestValidation_ValidateUnitWeakD_NULL_Pass()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitWeakD("1", "0", "P", null, "11", "P", Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Unknown);
        }

        [Test]
        public void TestValidation_ValidateUnitWeakD_Fail()
        {
            gov.va.med.vbecs.BOL.TestValidationModel validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateUnitWeakD("BUBU", "0", "P", new Guid(), "11", "P", Common.UnitStatusCode.Available);
            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
            Assert.AreEqual(validationResult.ErrorMessage, "An error occurred trying to validate this test.");
        }

        [Test]
        public void TestValidation_ValidatePatientABORh_Pass()
        {
            string AntiA = "";
            string AntiB = "";
            string AntiAB = "";
            string AntiD = "";
            string DControl = "";
            string A1Cells = "";
            string BCells = "";
            string ABOInterp = "";
            string RhInterp = "";
            string HistoricABO = "";
            string HistoricRh = "";
            string previousHistoricABO = "";
            string previousHistoricRh = "";
            vbecs.BOL.TestValidationModel validationResult;
            string output = "";
            int count = 0;
            bool testsPassed = true;
            System.IO.StreamWriter resultFile = null;

            DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient LEFT JOIN PatientSpecimen ON PatientSpecimen.PatientGuid = Patient.PatientGuid where BloodTypeCode IS NULL AND RhFactorCode IS NULL AND PatientSpecimenGuid IS NULL");
            Guid patientGuid = Guid.Empty;

            if (dtPatient.Rows.Count > 0)
            {
                patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
            }
            else
            {
                Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
                return;
            }

            Guid patientTreatmentGuid = Guid.NewGuid();
            string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
            insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
            insertPatientTreatment += "VALUES(";
            insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientTreatment += "'" + patientGuid.ToString() + "',";
            insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientTreatment += "'UnitTestUser',";
            insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientOrderGuid = Guid.NewGuid();
            string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
            insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
            insertPatientOrder += "VALUES(";
            insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
            insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientOrder += "'UnitTestUser',";
            insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid orderedTestGuid = Guid.NewGuid();
            string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
            insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
            insertOrderedTest += "VALUES (";
            insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
            insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
            insertOrderedTest += "'1',";
            insertOrderedTest += "'A',";
            insertOrderedTest += "'P',";
            insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertOrderedTest += "'UnitTestUser',";
            insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientSpecimenGuid = Guid.NewGuid();
            string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
            insertPatientSpecimen += "VALUES (";
            insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
            insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'A',";
            insertPatientSpecimen += "'0',";
            insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
            insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'UnitTestUser',";
            insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            UnitTestUtil.RunSQL(insertPatientTreatment);
            UnitTestUtil.RunSQL(insertPatientOrder);
            UnitTestUtil.RunSQL(insertOrderedTest);
            UnitTestUtil.RunSQL(insertPatientSpecimen);

            OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
            test.OrderableTest = "ABO/Rh";
            test.Patient.PatientGuid = patientGuid;
            //test.Patient = new Patient(patientGuid);

            try
            {
                resultFile = new System.IO.StreamWriter("\\\\DNS  SQLZUT\\AutobuildFiles\\TT_52Output" + DateTime.Now.ToString("yyMMddHHmmss") + ".txt");
               DataTable dtTT52 = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM dbo.TT52Checks order by HistoricalABO, HistoricalRh");
                //DataTable dtTT52 = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM dbo.TT52Checks WHERE ANTIA = 'N' AND ANTIB = 'N' AND ANTIAB = 'N' AND A1CELLS = 'P' AND BCELLS = 'P' AND ANTID = 'N' AND DCONTROL = 'N' AND USERABOINTERP = 'O' AND USERRHINTERP = 'N' AND HISTORICALABO = 'A' AND HISTORICALRH = 'I'");

                output = "Expected AntiA" + '\t' +
                         "Expected AntiB" + '\t' +
                         "Expected AntiAB" + '\t' +
                         "Expected A1Cells" + '\t' +
                         "Expected BCells" + '\t' +
                         "Expected AntiD" + '\t' +
                         "Expected DControl" + '\t' +
                         "Expected ABOInterp" + '\t' +
                         "Expected RhInterp" + '\t' +
                         "Expected HistoricABO" + '\t' +
                         "Expected HistoricRh" + '\t' +
                         "Expected Result" + '\t' +
                         "Expected Message" + '\t' +
                         "AntiA" + '\t' +
                         "AntiB" + '\t' +
                         "AntiAB" + '\t' +
                         "A1Cells" + '\t' +
                         "BCells" + '\t' +
                         "AntiD" + '\t' +
                         "DControl" + '\t' +
                         "ABOInterp" + '\t' +
                         "RhInterp" + '\t' +
                         "HistoricABO" + '\t' +
                         "HistoricRh" + '\t' +
                         "Validation Result" + '\t' +
                         "Validation Message";

                resultFile.WriteLine(output);

                for (int i = 0; i < dtTT52.Rows.Count; i++)
                {
                    count++;
                    AntiA = GetRandomTestResult(dtTT52.Rows[i]["AntiA"].ToString().Trim());
                    AntiB = GetRandomTestResult(dtTT52.Rows[i]["AntiB"].ToString().Trim());
                    AntiAB = GetRandomTestResult(dtTT52.Rows[i]["AntiAB"].ToString().Trim());
                    A1Cells = GetRandomTestResult(dtTT52.Rows[i]["A1Cells"].ToString().Trim());
                    BCells = GetRandomTestResult(dtTT52.Rows[i]["BCells"].ToString().Trim());
                    AntiD = GetRandomTestResult(dtTT52.Rows[i]["AntiD"].ToString().Trim());
                    DControl = GetRandomTestResult(dtTT52.Rows[i]["DControl"].ToString().Trim());
                    ABOInterp = dtTT52.Rows[i]["UserABOInterp"].ToString().Trim();
                    RhInterp = dtTT52.Rows[i]["UserRhInterp"].ToString().Trim();
                    HistoricABO = dtTT52.Rows[i]["HistoricalABO"].ToString().Trim();
                    HistoricRh = dtTT52.Rows[i]["HistoricalRh"].ToString().Trim();

                    if (previousHistoricABO != HistoricABO ||
                        previousHistoricRh != HistoricRh)
                    {
                        switch (HistoricABO)
                        {
                            case "NR":
                                test.Patient.AboRh.Abo = ABO.NA;
                                break;
                            case "I":
                                test.Patient.AboRh.Abo = ABO.I;
                                break;
                            case "A":
                                test.Patient.AboRh.Abo = ABO.A;
                                break;
                            case "B":
                                test.Patient.AboRh.Abo = ABO.B;
                                break;
                            case "AB":
                                test.Patient.AboRh.Abo = ABO.AB;
                                break;
                            case "O":
                                test.Patient.AboRh.Abo = ABO.O;
                                break;
                            default:
                                test.Patient.AboRh.Abo = ABO.NA;
                                break;
                        }

                        switch (HistoricRh)
                        {
                            case "NR":
                                test.Patient.AboRh.RH = RH.NotProvided;
                                break;
                            case "I":
                                test.Patient.AboRh.RH = RH.Inconclusive;
                                break;
                            case "P":
                                test.Patient.AboRh.RH = RH.Positive;
                                break;
                            case "N":
                                test.Patient.AboRh.RH = RH.Negative;
                                break;
                            default:
                                test.Patient.AboRh.RH = RH.NotProvided;
                                break;
                        }

                        previousHistoricRh = HistoricRh;
                        previousHistoricABO = HistoricABO;
                    }

                    validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh(AntiA, AntiB, AntiAB, A1Cells, BCells, AntiD,
                                                                DControl, ABOInterp, RhInterp, test, DateTime.Now.AddDays(3));

                    string finalValidationResult = dtTT52.Rows[i]["ABORhErrorCode"].ToString();

                    output = dtTT52.Rows[i]["AntiA"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["AntiB"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["AntiAB"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["A1Cells"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["BCells"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["AntiD"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["DControl"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["UserABOInterp"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["UserRhInterp"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["HistoricalABO"].ToString().Trim() + '\t' +
                             dtTT52.Rows[i]["HistoricalRh"].ToString().Trim() + '\t' +
                             finalValidationResult + '\t' +
                             dtTT52.Rows[i]["ABOResponseInfo"].ToString().Trim() + " " + dtTT52.Rows[i]["RhResponseInfo"].ToString().Trim() + '\t' +
                             AntiA + '\t' +
                             AntiB + '\t' +
                             AntiAB + '\t' +
                             A1Cells + '\t' +
                             BCells + '\t' +
                             AntiD + '\t' +
                             DControl + '\t' +
                             ABOInterp + '\t' +
                             RhInterp + '\t' +
                             HistoricABO + '\t' +
                             HistoricRh + '\t' +
                             validationResult.TestValidationStatus.ToString()[0] + '\t' +
                             validationResult.ErrorMessage.Replace(Environment.NewLine, " ");

                    resultFile.WriteLine(output);

                    string consoleOutput;
                    consoleOutput = dtTT52.Rows[i]["AntiA"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["AntiB"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["AntiAB"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["A1Cells"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["BCells"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["AntiD"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["DControl"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["UserABOInterp"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["UserRhInterp"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["HistoricalABO"].ToString().Trim() + '\t' +
                                    dtTT52.Rows[i]["HistoricalRh"].ToString().Trim() + '\t' +
                                    finalValidationResult + '\t' +
                                    validationResult.TestValidationStatus.ToString()[0] + '\t' +
                                    validationResult.ErrorMessage.Replace(Environment.NewLine, " ");

                    if (validationResult.TestValidationStatus == TestValidationStatus.Valid)
                    {
                        if (finalValidationResult != "V")
                        {
                            testsPassed = false;
                            Console.WriteLine(consoleOutput);
                        }
                    }
                    else if (validationResult.TestValidationStatus == TestValidationStatus.Warning)
                    {
                        if (finalValidationResult != "W")
                        {
                            testsPassed = false;
                            Console.WriteLine(consoleOutput);
                        }
                    }
                    else
                    {
                        if (finalValidationResult != "E")
                        {
                            testsPassed = false;
                            Console.WriteLine(consoleOutput);
                        }
                    }
                }
                //expired specimen
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh("2", "0", "X", "0", "2", "0", "0", "A","N", test, DateTime.Now.AddDays(-3));
                Assert.True(validationResult.ErrorMessage.Contains(Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString) );
                resultFile.Close();
                Console.WriteLine("Number of combinations tested: " + count);
                Assert.IsTrue(testsPassed);
                Assert.IsTrue(count == dtTT52.Rows.Count);

                UnitTestUtil.RunSQL("DELETE FROM PATIENTSPECIMEN WHERE PATIENTSPECIMENGUID = '" + patientSpecimenGuid.ToString() + "'");
                UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
                UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
                UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
                UnitTestUtil.RunSQL("UPDATE PATIENT SET BLOODTYPECODE = NULL, RHFACTORCODE = NULL WHERE PATIENTGUID = '" + patientGuid.ToString() + "'");
            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientABORh_92_06_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;

            try
            {

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'1',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'18',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'21',";
                insertSpecimenTest2 += "'P',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);

                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "ABO/Rh";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh("2", "0", "X", "0", "2", "2", "0", "A", "P",
                        test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

                specimenTestGuid = Guid.NewGuid();
                insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'18',";
                insertSpecimenTest += "'B',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                specimenTestGuid2 = Guid.NewGuid();
                insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'21',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh("2", "0", "X", "0", "2", "2", "0", "A", "P",
                        test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientABORh_115_18_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;

            try
            {

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'1',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'18',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'21',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);

                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "ABO/Rh";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh("2", "0", "X", "0", "2", "2", "0", "A", "P",
                        test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientABORh_115_27_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;

            try
            {

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'1',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'18',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'21',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);

                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "Repeat ABO/Rh";
                test.RelatedTestGuid = orderedTestGuid;

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh("2", "0", "X", "0", "2", "2", "0", "A", "P",
                        test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientABORh_56_29_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(), Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC).BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'1',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'18',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'21',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedComponentGuid = Guid.NewGuid();
                string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
                insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
                insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
                insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
                insertOrderedComponent += "VALUES (";
                insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedComponent += "'1',";
                insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
                insertOrderedComponent += "'2',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'A',";
                insertOrderedComponent += "'I',";
                insertOrderedComponent += "'" + this.TestDivisionCode + "',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedUnitGuid = Guid.NewGuid();
                string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
                insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
                insertOrderedUnit += "VALUES (";
                insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "1,";
                insertOrderedUnit += "'C',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'A',";
                insertOrderedUnit += "'" + this.TestDivisionCode + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid issuedUnitGuid = Guid.NewGuid();
                string insertIssuedUnit = "INSERT INTO IssuedUnit (";
                insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
                insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
                insertIssuedUnit += "VALUES (";
                insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'10W P-KC',";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "1,";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);

                UnitTestUtil.RunSQL(insertOrderedComponent);
                UnitTestUtil.RunSQL(insertOrderedUnit);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");
                UnitTestUtil.RunSQL(insertIssuedUnit);


                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "ABO/Rh";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh("2", "0", "X", "0", "2", "2", "0", "A", "P",
                        test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);

                //testing the exception here instead of creating a separate method for it
                validationResult =
                     gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABORh("KMan", "0", "X", "0", "2", "2", "0", "A", "P",
                       test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());

            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientABS_Pass()
        {
            string SC1 = "";
            string SC2 = "";
            string SC3 = "";
            string SC4 = "";
            string SC5 = "";
            string ABSInterp = "";
            vbecs.BOL.TestValidationModel validationResult;

            DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
            Guid patientGuid = Guid.Empty;

            if (dtPatient.Rows.Count > 0)
            {
                patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
            }
            else
            {
                Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
                return;
            }

            Guid patientTreatmentGuid = Guid.NewGuid();
            string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
            insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
            insertPatientTreatment += "VALUES(";
            insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientTreatment += "'" + patientGuid.ToString() + "',";
            insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientTreatment += "'UnitTestUser',";
            insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientOrderGuid = Guid.NewGuid();
            string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
            insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
            insertPatientOrder += "VALUES(";
            insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
            insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientOrder += "'UnitTestUser',";
            insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientSpecimenGuid = Guid.NewGuid();
            string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
            insertPatientSpecimen += "VALUES (";
            insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
            insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'A',";
            insertPatientSpecimen += "'0',";
            insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
            insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'UnitTestUser',";
            insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid orderedTestGuid = Guid.NewGuid();
            string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
            insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
            insertOrderedTest += "VALUES (";
            insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
            insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
            insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
            insertOrderedTest += "'3',";
            insertOrderedTest += "'A',";
            insertOrderedTest += "'P',";
            insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertOrderedTest += "'UnitTestUser',";
            insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";


            UnitTestUtil.RunSQL(insertPatientTreatment);
            UnitTestUtil.RunSQL(insertPatientOrder);
            UnitTestUtil.RunSQL(insertPatientSpecimen);
            UnitTestUtil.RunSQL(insertOrderedTest);

            OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
            test.OrderableTest = "ABO/Rh";

            try
            {
                for (int iSC1 = 0; iSC1 < _possibleTestResults.Length; iSC1++)
                {
                    for (int iSC2 = 0; iSC2 < _possibleTestResults.Length; iSC2++)
                    {
                        for (int iSC3 = 0; iSC3 < _possibleTestResults.Length; iSC3++)
                        {
                            for (int iSC4 = 0; iSC4 < _possibleTestResults.Length; iSC4++)
                            {
                                for (int iSC5 = 0; iSC5 < _possibleTestResults.Length; iSC5++)
                                {
                                    for (int iABSInterp = 0; iABSInterp < _rhInterps.Length; iABSInterp++)
                                    {
                                        SC1 =
                                            GetRandomTestResult(
                                                _possibleTestResults[iSC1].ToString());
                                        SC2 =
                                            GetRandomTestResult(
                                                _possibleTestResults[iSC2].ToString());
                                        SC3 =
                                            GetRandomTestResult(
                                                _possibleTestResults[iSC3].ToString());
                                        SC4 =
                                            GetRandomTestResult(
                                                _possibleTestResults[iSC4].ToString());
                                        SC5 =
                                            GetRandomTestResult(
                                                _possibleTestResults[iSC5].ToString());
                                        ABSInterp = _rhInterps[iABSInterp].ToString();
                                        validationResult =
                                            gov.va.med.vbecs.BOL.TestValidation
                                                .ValidatePatientABS(SC1, SC2, SC3, SC4, SC5, ABSInterp,
                                                    test, DateTime.Now.AddDays(3));

                                        if (ResultLookup[SC1].ToString() == "X" || ResultLookup[SC2].ToString() == "X")
                                            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                        else if (ResultLookup[SC1].ToString() == "P" ||
                                                 ResultLookup[SC2].ToString() == "P" ||
                                                 ResultLookup[SC3].ToString() == "P" ||
                                                 ResultLookup[SC4].ToString() == "P" ||
                                                 ResultLookup[SC5].ToString() == "P")
                                        {
                                            if (ABSInterp == "P")
                                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                                            else
                                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                        }
                                        else if (ResultLookup[SC1].ToString() == "N" &&
                                                ResultLookup[SC2].ToString() == "N")
                                        {
                                            if (ABSInterp == "N")
                                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                                            else
                                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                                        }
                                        else
                                            Assert.AreEqual(
                                                validationResult.TestValidationStatus,
                                                TestValidationStatus.Error);
                                    }
                                }

                            }

                        }

                    }
                }
                //expired specimen
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABS("2", "0", "2", "0", "2", "Pos", test, DateTime.Now.AddDays(-3));
                Assert.True(validationResult.ErrorMessage.Contains(Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString));

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientABS_56_29_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(), Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC).BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'3',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'18',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'21',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedComponentGuid = Guid.NewGuid();
                string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
                insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
                insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
                insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
                insertOrderedComponent += "VALUES (";
                insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedComponent += "'1',";
                insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
                insertOrderedComponent += "'2',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'A',";
                insertOrderedComponent += "'I',";
                insertOrderedComponent += "'" + this.TestDivisionCode + "',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedUnitGuid = Guid.NewGuid();
                string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
                insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
                insertOrderedUnit += "VALUES (";
                insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "1,";
                insertOrderedUnit += "'C',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'A',";
                insertOrderedUnit += "'" + this.TestDivisionCode + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid issuedUnitGuid = Guid.NewGuid();
                string insertIssuedUnit = "INSERT INTO IssuedUnit (";
                insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
                insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
                insertIssuedUnit += "VALUES (";
                insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'10W P-KC',";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "1,";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);

                UnitTestUtil.RunSQL(insertOrderedComponent);
                UnitTestUtil.RunSQL(insertOrderedUnit);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");
                UnitTestUtil.RunSQL(insertIssuedUnit);


                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "ABS";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABS("2", "2", "0", "0", "0", "P", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);

                //testing the exception here instead of creating a separate method for it
                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientABS("0", "KMan", "0", "0", "0", "N", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());

            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientDAT_Pass()
        {
            string Result = "";
            string DATInterp = "";
            vbecs.BOL.TestValidationModel validationResult;

            DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
            Guid patientGuid = Guid.Empty;

            if (dtPatient.Rows.Count > 0)
            {
                patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
            }
            else
            {
                Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
                return;
            }

            Guid patientTreatmentGuid = Guid.NewGuid();
            string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
            insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
            insertPatientTreatment += "VALUES(";
            insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientTreatment += "'" + patientGuid.ToString() + "',";
            insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientTreatment += "'UnitTestUser',";
            insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientOrderGuid = Guid.NewGuid();
            string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
            insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
            insertPatientOrder += "VALUES(";
            insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
            insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientOrder += "'UnitTestUser',";
            insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientSpecimenGuid = Guid.NewGuid();
            string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
            insertPatientSpecimen += "VALUES (";
            insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
            insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'A',";
            insertPatientSpecimen += "'0',";
            insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
            insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'UnitTestUser',";
            insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid orderedTestGuid = Guid.NewGuid();
            string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
            insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
            insertOrderedTest += "VALUES (";
            insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
            insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
            insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
            insertOrderedTest += "'4',";
            insertOrderedTest += "'A',";
            insertOrderedTest += "'P',";
            insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertOrderedTest += "'UnitTestUser',";
            insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";


            UnitTestUtil.RunSQL(insertPatientTreatment);
            UnitTestUtil.RunSQL(insertPatientOrder);
            UnitTestUtil.RunSQL(insertPatientSpecimen);
            UnitTestUtil.RunSQL(insertOrderedTest);

            OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
            test.OrderableTest = "ABO/Rh";

            try
            {
                for (int iResult = 0; iResult < _possibleTestResults.Length; iResult++)
                {
                    for (int iDATInterp = 0; iDATInterp < _rhInterps.Length; iDATInterp++)
                    {
                        Result =
                            GetRandomTestResult(
                                _possibleTestResults[iResult].ToString());
                        DATInterp = _rhInterps[iDATInterp].ToString();
                        validationResult =
                            gov.va.med.vbecs.BOL.TestValidation
                                .ValidatePatientDAT(Result, DATInterp,
                                    test, DateTime.Now.AddDays(3));

                        if (ResultLookup[Result].ToString() == "X" || DATInterp == "X")
                            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                        else if (ResultLookup[Result].ToString() == DATInterp)
                            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                        else
                            Assert.AreEqual(
                                validationResult.TestValidationStatus,
                                TestValidationStatus.Error);

                    }
                }
                //expired specimen
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidatePatientDAT("2", "Pos", test, DateTime.Now.AddDays(-3));
                Assert.True(validationResult.ErrorMessage.Contains(Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString));

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientDAT_56_29_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(), Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC).BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'4',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'18',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'21',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedComponentGuid = Guid.NewGuid();
                string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
                insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
                insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
                insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
                insertOrderedComponent += "VALUES (";
                insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedComponent += "'1',";
                insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
                insertOrderedComponent += "'2',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'A',";
                insertOrderedComponent += "'I',";
                insertOrderedComponent += "'" + this.TestDivisionCode + "',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedUnitGuid = Guid.NewGuid();
                string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
                insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
                insertOrderedUnit += "VALUES (";
                insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "1,";
                insertOrderedUnit += "'C',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'A',";
                insertOrderedUnit += "'" + this.TestDivisionCode + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid issuedUnitGuid = Guid.NewGuid();
                string insertIssuedUnit = "INSERT INTO IssuedUnit (";
                insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
                insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
                insertIssuedUnit += "VALUES (";
                insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'10W P-KC',";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "1,";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);

                UnitTestUtil.RunSQL(insertOrderedComponent);
                UnitTestUtil.RunSQL(insertOrderedUnit);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");
                UnitTestUtil.RunSQL(insertIssuedUnit);


                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "DAT";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientDAT("2", "P", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);

                //testing the exception here instead of creating a separate method for it
                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientDAT("0", "KMan", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());

            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientAntigentyping_Pass()
        {
            string Result = "";
            string AGInterp = "";
            vbecs.BOL.TestValidationModel validationResult;

            DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient");
            Guid patientGuid = Guid.Empty;

            if (dtPatient.Rows.Count > 0)
            {
                patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
            }
            else
            {
                Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
                return;
            }

            Guid patientTreatmentGuid = Guid.NewGuid();
            string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
            insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
            insertPatientTreatment += "VALUES(";
            insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientTreatment += "'" + patientGuid.ToString() + "',";
            insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientTreatment += "'UnitTestUser',";
            insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientOrderGuid = Guid.NewGuid();
            string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
            insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
            insertPatientOrder += "VALUES(";
            insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
            insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientOrder += "'UnitTestUser',";
            insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientSpecimenGuid = Guid.NewGuid();
            string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
            insertPatientSpecimen += "VALUES (";
            insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
            insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'A',";
            insertPatientSpecimen += "'0',";
            insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
            insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'UnitTestUser',";
            insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid orderedTestGuid = Guid.NewGuid();
            string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
            insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
            insertOrderedTest += "VALUES (";
            insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
            insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
            insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
            insertOrderedTest += "'12',";
            insertOrderedTest += "'A',";
            insertOrderedTest += "'P',";
            insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertOrderedTest += "'UnitTestUser',";
            insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";


            UnitTestUtil.RunSQL(insertPatientTreatment);
            UnitTestUtil.RunSQL(insertPatientOrder);
            UnitTestUtil.RunSQL(insertPatientSpecimen);
            UnitTestUtil.RunSQL(insertOrderedTest);

            OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
            test.OrderableTest = "AGC";

            try
            {
                for (int iResult = 0; iResult < _possibleTestResults.Length; iResult++)
                {
                    for (int iAGInterp = 0; iAGInterp < _rhInterps.Length; iAGInterp++)
                    {
                        Result =
                            GetRandomTestResult(
                                _possibleTestResults[iResult].ToString());
                        AGInterp = _rhInterps[iAGInterp].ToString();
                        validationResult =
                            gov.va.med.vbecs.BOL.TestValidation
                                .ValidatePatientAntigentyping(Result, AGInterp,
                                    test, DateTime.Now.AddDays(3));

                        if (ResultLookup[Result].ToString() == "X" || AGInterp == "X")
                            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                        else if (ResultLookup[Result].ToString() == AGInterp)
                            Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                        else
                            Assert.AreEqual(
                                validationResult.TestValidationStatus,
                                TestValidationStatus.Error);

                    }
                }
                //expired specimen
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidatePatientAntigentyping("2", "Pos", test, DateTime.Now.AddDays(-3));
                Assert.True(validationResult.ErrorMessage.Contains(Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString));

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientAntigentyping_98_01_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(), Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC).BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'12',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'207',";
                insertSpecimenTest += "'0',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'212',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";


                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);


                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "AGC";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientAntigentyping("2", "P", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);

                //testing the exception here instead of creating a separate method for it
                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientAntigentyping("2", "KMan", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());

            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientWeakD_Pass()
        {
            string Result = "";
            string CC = "";
            string WeakDInterp = "";
            vbecs.BOL.TestValidationModel validationResult;

            DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM dbo.Patient where BloodTypeCode IS NULL AND RhFactorCode IS NULL");
            Guid patientGuid = Guid.Empty;

            if (dtPatient.Rows.Count > 0)
            {
                patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
            }
            else
            {
                Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
                return;
            }

            Guid patientTreatmentGuid = Guid.NewGuid();
            string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
            insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
            insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
            insertPatientTreatment += "VALUES(";
            insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientTreatment += "'" + patientGuid.ToString() + "',";
            insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientTreatment += "'UnitTestUser',";
            insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientOrderGuid = Guid.NewGuid();
            string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
            insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
            insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
            insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
            insertPatientOrder += "VALUES(";
            insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
            insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
            insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientOrder += "'UnitTestUser',";
            insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid patientSpecimenGuid = Guid.NewGuid();
            string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
            insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
            insertPatientSpecimen += "VALUES (";
            insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
            insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'A',";
            insertPatientSpecimen += "'0',";
            insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
            insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertPatientSpecimen += "'UnitTestUser',";
            insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            Guid orderedTestGuid = Guid.NewGuid();
            string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
            insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
            insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
            insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
            insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
            insertOrderedTest += "VALUES (";
            insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
            insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
            insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
            insertOrderedTest += "'11',";
            insertOrderedTest += "'A',";
            insertOrderedTest += "'P',";
            insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
            insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
            insertOrderedTest += "'UnitTestUser',";
            insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";


            UnitTestUtil.RunSQL(insertPatientTreatment);
            UnitTestUtil.RunSQL(insertPatientOrder);
            UnitTestUtil.RunSQL(insertPatientSpecimen);
            UnitTestUtil.RunSQL(insertOrderedTest);

            OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
            test.OrderableTest = "AGwD";

            try
            {
                for (int iResult = 0; iResult < _possibleTestResults.Length; iResult++)
                {
                    for (int iCC = 0; iCC < _possibleTestResults.Length; iCC++)
                    {
                        for (int iWeakDInterp = 0; iWeakDInterp < _rhInterps.Length; iWeakDInterp++)
                        {
                            Result =
                                GetRandomTestResult(
                                    _possibleTestResults[iResult].ToString());
                            CC =
                               GetRandomTestResult(
                                   _possibleTestResults[iCC].ToString());
                            WeakDInterp = _rhInterps[iWeakDInterp].ToString();
                            validationResult =
                                gov.va.med.vbecs.BOL.TestValidation
                                    .ValidatePatientWeakD(Result, CC, WeakDInterp,
                                        test, DateTime.Now.AddDays(3));

                            if (ResultLookup[Result].ToString() == "X" || WeakDInterp == "X")
                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                            else if (ResultLookup[Result].ToString() == WeakDInterp && (ResultLookup[CC].ToString() == "N" || ResultLookup[CC].ToString() == "X"))
                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                            else
                                Assert.AreEqual(
                                    validationResult.TestValidationStatus,
                                    TestValidationStatus.Error);

                        }
                    }
                }
                //expired specimen
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidatePatientWeakD("2", "0", "Pos", test, DateTime.Now.AddDays(-3));
                Assert.True(validationResult.ErrorMessage.Contains(Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString));

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientWeakD_98_01_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(), Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC).BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;

                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "N" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'11',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid = Guid.NewGuid();
                string insertSpecimenTest = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest += "VALUES (";
                insertSpecimenTest += "'" + specimenTestGuid.ToString() + "',";
                insertSpecimenTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest += "'29',";
                insertSpecimenTest += "'0',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'A',";
                insertSpecimenTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest += "'UnitTestUser',";
                insertSpecimenTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid2 = Guid.NewGuid();
                string insertSpecimenTest2 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest2 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest2 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest2 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest2 += "VALUES (";
                insertSpecimenTest2 += "'" + specimenTestGuid2.ToString() + "',";
                insertSpecimenTest2 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest2 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest2 += "'206',";
                insertSpecimenTest2 += "'N',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'A',";
                insertSpecimenTest2 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest2 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest2 += "'UnitTestUser',";
                insertSpecimenTest2 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid specimenTestGuid3 = Guid.NewGuid();
                string insertSpecimenTest3 = "INSERT INTO SPECIMENTEST (";
                insertSpecimenTest3 += TABLES.SpecimenTest.SpecimenTestGuid + ",";
                insertSpecimenTest3 += TABLES.SpecimenTest.PatientSpecimenGuid + ",";
                insertSpecimenTest3 += TABLES.SpecimenTest.OrderedTestGuid + ",";
                insertSpecimenTest3 += TABLES.SpecimenTest.BloodTestTypeId + ",";
                insertSpecimenTest3 += TABLES.SpecimenTest.TestResultId + ",";
                insertSpecimenTest3 += TABLES.SpecimenTest.TestDate + ",";
                insertSpecimenTest3 += TABLES.SpecimenTest.RecordStatusCode + ",";
                insertSpecimenTest3 += TABLES.PatientSpecimen.DivisionCode + ",";
                insertSpecimenTest3 += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertSpecimenTest3 += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertSpecimenTest3 += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertSpecimenTest3 += "VALUES (";
                insertSpecimenTest3 += "'" + specimenTestGuid3.ToString() + "',";
                insertSpecimenTest3 += "'" + patientSpecimenGuid.ToString() + "',";
                insertSpecimenTest3 += "'" + orderedTestGuid.ToString() + "',";
                insertSpecimenTest3 += "'204',";
                insertSpecimenTest3 += "'0',";
                insertSpecimenTest3 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest3 += "'A',";
                insertSpecimenTest3 += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertSpecimenTest3 += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertSpecimenTest3 += "'UnitTestUser',";
                insertSpecimenTest3 += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";


                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);
                UnitTestUtil.RunSQL(insertSpecimenTest);
                UnitTestUtil.RunSQL(insertSpecimenTest2);
                UnitTestUtil.RunSQL(insertSpecimenTest3);


                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "AGwD";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientWeakD("2", "0","P", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);

                //testing the exception here instead of creating a separate method for it
                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientWeakD("2", "0", "KMan", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());

            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidatePatientWeakD_98_02_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;

            try
            {
                Guid patientGuid = Guid.NewGuid();
                // Patient
                string sqlPatient = "INSERT INTO PATIENT (";
                sqlPatient += TABLES.Patient.PatientGuid + ",";
                sqlPatient += TABLES.Patient.PatientSsn + ",";
                sqlPatient += TABLES.Patient.VistaPatientId + ",";
                sqlPatient += TABLES.Patient.PatientLastName + ",";
                sqlPatient += TABLES.Patient.PatientFirstName + ",";
                sqlPatient += TABLES.Patient.PatientDob + ",";
                sqlPatient += TABLES.Patient.PatientDobCode + ",";
                sqlPatient += TABLES.Patient.BloodTypeCode + ",";
                sqlPatient += TABLES.Patient.RhFactorCode + ",";
                sqlPatient += TABLES.Patient.RecordStatusCode + ",";
                sqlPatient += TABLES.Patient.LastUpdateDate + ",";
                sqlPatient += TABLES.Patient.LastUpdateUser + ",";
                sqlPatient += TABLES.Patient.LastUpdateFunctionId + ")";
                sqlPatient += "VALUES(";
                sqlPatient += "'" + patientGuid.ToString() + "',";
                sqlPatient += "'" + new Random().Next(11111, 99999).ToString() +
                              new Random().Next(1111, 9999).ToString() + "',";
                sqlPatient += "'" + DataCreator.GetVistaPatientId().ToString() + "',";
                sqlPatient += "'CreateXMatchBUTData',";
                sqlPatient += "'SprocHelper',";
                sqlPatient += "'" + DateTime.Today.AddYears(-50) + "',";
                sqlPatient += "'V',";
                sqlPatient += "'" + "A" + "',";
                sqlPatient += "'" + "P" + "',";
                sqlPatient += "'" +
                              Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() +
                              "',";
                sqlPatient += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sqlPatient += "'" + Common.LogonUser.LogonUserName + "',";
                sqlPatient += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO dbo.PatientTREATMENT (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'UnitTestUser',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientSpecimenGuid = Guid.NewGuid();
                string insertPatientSpecimen = "INSERT INTO dbo.PatientSPECIMEN (";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientSpecimenGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.PatientGuid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenCollectionDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenStatusCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.UnacceptableSpecimenIndicator + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.SpecimenUid + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.DivisionCode + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateDate + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateUser + ",";
                insertPatientSpecimen += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
                insertPatientSpecimen += "VALUES (";
                insertPatientSpecimen += "'" + patientSpecimenGuid.ToString() + "',";
                insertPatientSpecimen += "'" + patientGuid.ToString() + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'A',";
                insertPatientSpecimen += "'0',";
                insertPatientSpecimen += "'" + DataCreator.GetNewSpecimenUid() + "',";
                insertPatientSpecimen += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientSpecimen += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientSpecimen += "'UnitTestUser',";
                insertPatientSpecimen += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO dbo.PatientORDER (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'UnitTestUser',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedTestGuid = Guid.NewGuid();
                string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
                insertOrderedTest += TABLES.OrderedTest.OrderedTestGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientOrderGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.PatientSpecimenGuid + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderableTestId + ",";
                insertOrderedTest += TABLES.OrderedTest.OrderStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.TaskStatusCode + ",";
                insertOrderedTest += TABLES.OrderedTest.DivisionCode + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateDate + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateUser + ",";
                insertOrderedTest += TABLES.OrderedTest.LastUpdateFunctionId + ")";
                insertOrderedTest += "VALUES (";
                insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
                insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedTest += "'" + patientSpecimenGuid.ToString() + "',";
                insertOrderedTest += "'11',";
                insertOrderedTest += "'A',";
                insertOrderedTest += "'P',";
                insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
                insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedTest += "'UnitTestUser',";
                insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sqlPatient);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientSpecimen);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedTest);

                OrderedTest test = new OrderedTest(orderedTestGuid, patientOrderGuid);
                test.OrderableTest = "AGwD";

                validationResult =
                    gov.va.med.vbecs.BOL.TestValidation.ValidatePatientWeakD("2", "0", "P", test, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);

            }
            catch (Exception e)
            {
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidateXM_Pass()
        {
            string ISResult = "";
            string AHGResult = "";
            string XMInterp = "";
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;

            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);

                for (int iISResult = 0; iISResult < _possibleTestResults.Length; iISResult++)
                {
                    for (int iAHGResult = 0; iAHGResult < _possibleTestResults.Length; iAHGResult++)
                    {
                        for (int iXMInterp = 0; iXMInterp < _xmInterps.Length; iXMInterp++)
                        {
                            ISResult = GetRandomTestResult(_possibleTestResults[iISResult].ToString());
                            AHGResult = GetRandomTestResult(_possibleTestResults[iAHGResult].ToString());
                            XMInterp = _xmInterps[iXMInterp].ToString();

                            validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateXM(ISResult, AHGResult, "X", "X", XMInterp, bloodUnit.BloodUnitGuid, DateTime.Now.AddDays(3));
                            if (ResultLookup[ISResult].ToString() == "X" && ResultLookup[AHGResult].ToString() == "X")
                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                            else if (ResultLookup[AHGResult].ToString() == "N" && (ResultLookup[ISResult].ToString() == "N" || ResultLookup[ISResult].ToString() == "X") && XMInterp == "Compatible")
                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                            else if (ResultLookup[AHGResult].ToString() == "P" && XMInterp == "Incompatible")
                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                            else if (ResultLookup[AHGResult].ToString() == "N" && ResultLookup[ISResult].ToString() == "P" && XMInterp == "Incompatible")
                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Valid);
                            else
                                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                        }
                    }
                }

                //testing null
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateXM("0", "0", "X", "X", "Compatible", null, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Unknown);

                //testing 92.09
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateXM("0", "0", "X", "X", "Compatible", bloodUnit.BloodUnitGuid, DateTime.Now.AddDays(-3));
                Assert.True(validationResult.ErrorMessage.Contains(Common.StrRes.ConfMsg.UC056.ExpiredTaskProcessed().ResString));

                //testing exception
                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateXM("Doug", "0", "X", "X", "Compatible", bloodUnit.BloodUnitGuid, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Error);
                DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }

        }

        [Test]
        public void TestValidation_ValidateXM_56_29_Pass()
        {
            vbecs.BOL.TestValidationModel validationResult;
            gov.va.med.vbecs.BOL.BloodUnit bloodUnit = null;
            try
            {
                bloodUnit = DataCreator.CreateBloodUnit(Guid.NewGuid(), Guid.NewGuid(),
                    Guid.Empty,
                    DataCreator.GetRandomBloodProduct(false, Common.ComponentClass.RBC)
                        .BloodProductGuid, Common.ABO.A, Common.RH.Positive, this.TestDivisionCode, false);
                System.Guid bloodUnitGuid = bloodUnit.BloodUnitGuid;
                Guid _patientGuid = DataCreator.GetRandomRecordGuid(TABLES.Patient.TableName, "");

                Guid patientTransfusionRequirementGuid = Guid.NewGuid();
                string sSQLInsertPTR = "INSERT INTO PatientTransfusionRequirement (";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.PatientGuid + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.TransfusionRequirementText + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.AntibodyTypeId + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.AntigenTypeId + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.CreateDate + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.CreateUser + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.RecordStatusCode + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateDate + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateUser + ",";
                sSQLInsertPTR += TABLES.PatientTransfusionRequirement.LastUpdateFunctionId + ")";
                sSQLInsertPTR += "VALUES(";
                sSQLInsertPTR += "'" + patientTransfusionRequirementGuid.ToString() + "',";
                sSQLInsertPTR += "'" + _patientGuid.ToString() + "',";
                sSQLInsertPTR += "'K',";
                sSQLInsertPTR += "'" + Common.Utility.GetTransfusionCategoryCodeFromEnum(Common.TransfusionRequirementCategoryCode.AntigenNegative) + "',";
                sSQLInsertPTR += "'29',";
                sSQLInsertPTR += "'37',";
                sSQLInsertPTR += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sSQLInsertPTR += "'" + Common.LogonUser.LogonUserName + "',";
                sSQLInsertPTR += "'" + Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString() + "',";
                sSQLInsertPTR += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                sSQLInsertPTR += "'" + Common.LogonUser.LogonUserName + "',";
                sSQLInsertPTR += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientTreatmentGuid = Guid.NewGuid();
                string insertPatientTreatment = "INSERT INTO PatientTreatment (";
                insertPatientTreatment += TABLES.PatientTreatment.PatientTreatmentGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.PatientGuid + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateDate + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateUser + ",";
                insertPatientTreatment += TABLES.PatientTreatment.LastUpdateFunctionId + ")";
                insertPatientTreatment += "VALUES(";
                insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientTreatment += "'" + _patientGuid.ToString() + "',";
                insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientTreatment += "'" + Common.LogonUser.LogonUserName + "',";
                insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid patientOrderGuid = Guid.NewGuid();
                string insertPatientOrder = "INSERT INTO PatientOrder (";
                insertPatientOrder += TABLES.PatientOrder.PatientOrderGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.PatientTreatmentGuid + ",";
                insertPatientOrder += TABLES.PatientOrder.DivisionCode + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateDate + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateUser + ",";
                insertPatientOrder += TABLES.PatientOrder.LastUpdateFunctionId + ")";
                insertPatientOrder += "VALUES(";
                insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
                insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
                insertPatientOrder += "'" + this.TestDivisionCode + "',";
                insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertPatientOrder += "'" + Common.LogonUser.LogonUserName + "',";
                insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedComponentGuid = Guid.NewGuid();
                string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
                insertOrderedComponent += TABLES.OrderedComponent.OrderedComponentGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.PatientOrderGuid + ",";
                insertOrderedComponent += TABLES.OrderedComponent.ComponentClassId + ",";
                insertOrderedComponent += TABLES.OrderedComponent.CprsOrderNumber + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredUnitQuantity + ",";
                insertOrderedComponent += TABLES.OrderedComponent.RequiredDatetime + ",";
                insertOrderedComponent += TABLES.OrderedComponent.OrderStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.TaskStatusCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.DivisionCode + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateDate + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateUser + ",";
                insertOrderedComponent += TABLES.OrderedComponent.LastUpdateFunctionId + ")";
                insertOrderedComponent += "VALUES (";
                insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
                insertOrderedComponent += "'1',";
                insertOrderedComponent += "'" + DataCreator.GetNewCprsOrderNumber() + "',";
                insertOrderedComponent += "'2',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'A',";
                insertOrderedComponent += "'I',";
                insertOrderedComponent += "'" + this.TestDivisionCode + "',";
                insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedComponent += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid orderedUnitGuid = Guid.NewGuid();
                string insertOrderedUnit = "INSERT INTO ORDEREDUNIT (";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.OrderedComponentGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.BloodUnitGuid + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchRequiredIndicator + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchResultCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.CrossmatchTechId + ",";
                insertOrderedUnit += TABLES.OrderedUnit.RecordStatusCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.DivisionCode + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateDate + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateUser + ",";
                insertOrderedUnit += TABLES.OrderedUnit.LastUpdateFunctionId + ")";
                insertOrderedUnit += "VALUES (";
                insertOrderedUnit += "'" + orderedUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + orderedComponentGuid.ToString() + "',";
                insertOrderedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "1,";
                insertOrderedUnit += "'C',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'A',";
                insertOrderedUnit += "'" + this.TestDivisionCode + "',";
                insertOrderedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertOrderedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertOrderedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                Guid issuedUnitGuid = Guid.NewGuid();
                string insertIssuedUnit = "INSERT INTO IssuedUnit (";
                insertIssuedUnit += TABLES.IssuedUnit.IssuedUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.BloodUnitGuid + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueDateTime + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueTechId + ",";
                insertIssuedUnit += TABLES.IssuedUnit.TransporterName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueToLocationName + ",";
                insertIssuedUnit += TABLES.IssuedUnit.InPatientLocationIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.IssueSatisfactoryIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.RemoteStorageIndicator + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateDate + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateUser + ",";
                insertIssuedUnit += TABLES.IssuedUnit.LastUpdateFunctionId + ")";
                insertIssuedUnit += "VALUES (";
                insertIssuedUnit += "'" + issuedUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + bloodUnitGuid.ToString() + "',";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'10W P-KC',";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "1,";
                insertIssuedUnit += "0,";
                insertIssuedUnit += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
                insertIssuedUnit += "'" + Common.LogonUser.LogonUserName + "',";
                insertIssuedUnit += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

                UnitTestUtil.RunSQL(sSQLInsertPTR);
                UnitTestUtil.RunSQL(insertPatientTreatment);
                UnitTestUtil.RunSQL(insertPatientOrder);
                UnitTestUtil.RunSQL(insertOrderedComponent);
                UnitTestUtil.RunSQL(insertOrderedUnit);
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");
                DataCreator.InsertBloodUnitTest(Guid.NewGuid(), bloodUnit.BloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");
                UnitTestUtil.RunSQL(insertIssuedUnit);

                validationResult = gov.va.med.vbecs.BOL.TestValidation.ValidateXM("2", "2", "Incompatible", "Incompatible", "Incompatible",bloodUnitGuid, DateTime.Now.AddDays(3));
                Assert.AreEqual(validationResult.TestValidationStatus, TestValidationStatus.Warning);
                DataKiller.ClearBloodUnitData(bloodUnitGuid.ToString());
            }
            catch (Exception e)
            {
                if (bloodUnit != null)
                    DataKiller.ClearBloodUnitData(bloodUnit.BloodUnitGuid.ToString());
                throw e;
            }
        }

        /// <summary>
        /// Convertes P, N, X into actual results like 1,2,3,4,0,X,"" using arrays defined at the beginning of this class
        /// </summary>
        /// <param name="testResult"></param>
        /// <returns></returns>
        private string GetRandomTestResult(string testResult)
        {
            if (testResult == "P")
            {
                return _posTestResults[_rnd.Next(_posTestResults.Length - 1)].ToString();
            }
            else if (testResult == "N")
            {
                return _negTestResults[_rnd.Next(_negTestResults.Length - 1)].ToString();
            }
            else if (testResult == "X")
            {
                return _notTestedResults[_rnd.Next(_notTestedResults.Length - 1)].ToString();
            }
            else throw new Exception("Unexpected test result " + testResult);
        }

        private vbecs.BOL.AboRh CalculateUnitABORh(string AntiA, string AntiB, string AntiAB, string AntiD, string DControl)
        {
            AntiA = ResultLookup[AntiA.Trim()].ToString();
            AntiB = ResultLookup[AntiB.Trim()].ToString();
            AntiAB = ResultLookup[AntiAB.Trim()].ToString();
            AntiD = ResultLookup[AntiD.Trim()].ToString();
            DControl = ResultLookup[DControl.Trim()].ToString();
            
            if ((AntiA == "P" && AntiB == "N" && AntiAB == "P" && AntiD == "N" && DControl == "N") ||
                    (AntiA == "P" && AntiB == "N" && AntiAB == "X" && AntiD == "N" && DControl == "N") ||
                    (AntiA == "P" && AntiB == "N" && AntiAB == "P" && AntiD == "N" && DControl == "X") ||
                    (AntiA == "P" && AntiB == "N" && AntiAB == "X" && AntiD == "N" && DControl == "X"))
            {
                return new AboRh(ABO.A, RH.Negative);
            }
            else if ((AntiA == "P" && AntiB == "N" && AntiAB == "P" && AntiD == "P" && DControl == "N") ||
                    (AntiA == "P" && AntiB == "N" && AntiAB == "X" && AntiD == "P" && DControl == "N") ||
                    (AntiA == "P" && AntiB == "N" && AntiAB == "P" && AntiD == "P" && DControl == "X") ||
                    (AntiA == "P" && AntiB == "N" && AntiAB == "X" && AntiD == "P" && DControl == "X"))
            {
                return new AboRh(ABO.A, RH.Positive);
            }
            else if ((AntiA == "P" && AntiB == "N" && AntiAB == "P" && DControl == "P") ||
                     (AntiA == "P" && AntiB == "N" && AntiAB == "X" && DControl == "P"))
            {
                return new AboRh(ABO.A, RH.Inconclusive);
            }
            else if ((AntiA == "N" && AntiB == "P" && AntiAB == "P" && AntiD == "N" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "P" && AntiAB == "X" && AntiD == "N" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "P" && AntiAB == "P" && AntiD == "N" && DControl == "X") ||
                     (AntiA == "N" && AntiB == "P" && AntiAB == "X" && AntiD == "N" && DControl == "X"))
            {
                return new AboRh(ABO.B, RH.Negative);
            }
            else if ((AntiA == "N" && AntiB == "P" && AntiAB == "P" && AntiD == "P" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "P" && AntiAB == "X" && AntiD == "P" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "P" && AntiAB == "P" && AntiD == "P" && DControl == "X") ||
                     (AntiA == "N" && AntiB == "P" && AntiAB == "X" && AntiD == "P" && DControl == "X"))
            {
                return new AboRh(ABO.B, RH.Positive);
            }
            else if ((AntiA == "N" && AntiB == "P" && AntiAB == "P" && DControl == "P") ||
                    (AntiA == "N" && AntiB == "P" && AntiAB == "X" && DControl == "P"))
            {
                return new AboRh(ABO.B, RH.Inconclusive);
            }
            else if ((AntiA == "P" && AntiB == "P" && AntiAB == "P" && AntiD == "N" && DControl == "N") ||
                     (AntiA == "P" && AntiB == "P" && AntiAB == "X" && AntiD == "N" && DControl == "N") ||
                     (AntiA == "P" && AntiB == "P" && AntiAB == "P" && AntiD == "N" && DControl == "X") ||
                     (AntiA == "P" && AntiB == "P" && AntiAB == "X" && AntiD == "N" && DControl == "X"))
            {
                return new AboRh(ABO.AB, RH.Negative);
            }
            else if ((AntiA == "P" && AntiB == "P" && AntiAB == "P" && AntiD == "P" && DControl == "N") ||
                     (AntiA == "P" && AntiB == "P" && AntiAB == "X" && AntiD == "P" && DControl == "N") ||
                     (AntiA == "P" && AntiB == "P" && AntiAB == "P" && AntiD == "P" && DControl == "X") ||
                     (AntiA == "P" && AntiB == "P" && AntiAB == "X" && AntiD == "P" && DControl == "X"))
            {
                return new AboRh(ABO.AB, RH.Positive);
            }
            else if ((AntiA == "P" && AntiB == "P" && AntiAB == "P" && DControl == "P") ||
                     (AntiA == "P" && AntiB == "P" && AntiAB == "X" && DControl == "P"))
            {
                return new AboRh(ABO.AB, RH.Inconclusive);
            }
            else if ((AntiA == "N" && AntiB == "N" && AntiAB == "N" && AntiD == "N" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "N" && AntiAB == "X" && AntiD == "N" && DControl == "N") ||
                     (AntiA == "X" && AntiB == "X" && AntiAB == "N" && AntiD == "N" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "N" && AntiAB == "N" && AntiD == "N" && DControl == "X") ||
                     (AntiA == "N" && AntiB == "N" && AntiAB == "X" && AntiD == "N" && DControl == "X") ||
                     (AntiA == "X" && AntiB == "X" && AntiAB == "N" && AntiD == "N" && DControl == "X"))
            {
                return new AboRh(ABO.O, RH.Negative);
            }
            else if ((AntiA == "N" && AntiB == "N" && AntiAB == "N" && AntiD == "P" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "N" && AntiAB == "X" && AntiD == "P" && DControl == "N") ||
                     (AntiA == "X" && AntiB == "X" && AntiAB == "N" && AntiD == "P" && DControl == "N") ||
                     (AntiA == "N" && AntiB == "N" && AntiAB == "N" && AntiD == "P" && DControl == "X") ||
                     (AntiA == "N" && AntiB == "N" && AntiAB == "X" && AntiD == "P" && DControl == "X") ||
                     (AntiA == "X" && AntiB == "X" && AntiAB == "N" && AntiD == "P" && DControl == "X"))
            {
                return new AboRh(ABO.O, RH.Positive);
            }
            else if ((AntiA == "N" && AntiB == "N" && AntiAB == "N" && DControl == "P") ||
                    (AntiA == "N" && AntiB == "N" && AntiAB == "X" && DControl == "P") ||
                    (AntiA == "X" && AntiB == "X" && AntiAB == "N" && DControl == "P"))
            {
                return new AboRh(ABO.O, RH.Inconclusive);
            }
            else return null;
        }

        private vbecs.BOL.AboRh CalculatePatientABORh(string AntiA, string AntiB, string AntiAB, string A1Cells, string BCells, string AntiD, string DControl)
        {
            AntiA = ResultLookup[AntiA.Trim()].ToString();
            AntiB = ResultLookup[AntiB.Trim()].ToString();
            AntiAB = ResultLookup[AntiAB.Trim()].ToString();
            AntiD = ResultLookup[AntiD.Trim()].ToString();
            DControl = ResultLookup[DControl.Trim()].ToString();
            A1Cells = ResultLookup[A1Cells.Trim()].ToString();
            BCells = ResultLookup[BCells.Trim()].ToString();

            ABO abo = ABO.NA;
            RH rh = RH.Blank;

            if (AntiA == "N" && AntiB == "N" && (AntiAB == "X" || AntiAB == "N") && A1Cells == "P" && BCells == "P")
            {
                abo = ABO.O;
            }
            else if (AntiA == "P" && AntiB == "N" && (AntiAB == "X" || AntiAB == "P") && A1Cells == "N" && BCells == "P")
            {
                abo = ABO.A;
            }
            else if (AntiA == "N" && AntiB == "P" && (AntiAB == "X" || AntiAB == "P") && A1Cells == "P" && BCells == "N")
            {
                abo = ABO.B;
            }
            else if (AntiA == "P" && AntiB == "P" && (AntiAB == "X" || AntiAB == "P") && A1Cells == "N" && BCells == "N")
            {
                abo = ABO.AB;
            }

            if (AntiD == "P" && (DControl == "N" || DControl == "X"))
            {
                rh = RH.Positive;
            }
            else if (AntiD == "N" && (DControl == "N" || DControl == "X"))
            {
                rh = RH.Negative;
            }

            if (abo != ABO.NA && rh != RH.Blank)
                return new AboRh(abo, rh);
            else return null;
        }
    }
}

#endif
